/*   
THIS SOFTWARE IS PROVIDED BY ANALOG DEVICES INC. ``AS IS'' AND ANY EXPRESS OR 
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF 
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR NON-INFRINGEMENT, ARE 
DISCLAIMED. IN NO EVENT SHALL ANALOG DEVICES INC. BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.

YOU ASSUME ANY AND ALL RISK FROM THE USE OF THIS CODE OR SUPPORT FILE.  

IT IS THE RESPONSIBILITY OF THE PERSON INTEGRATING THIS CODE INTO AN APPLICATION
TO ENSURE THAT THE RESULTING APPLICATION PERFORMS AS REQUIRED AND IS SAFE.

    Module       : defs.h
    Description  : Global definitions
    Date         : 10 June 2010
    Version      : v1.00
    Changelog    : v1.00 Initial
*/

#define ASIZE(x) (sizeof(x)/sizeof(x[0]))

typedef signed long                    S32;
typedef signed short                   S16;
typedef signed char                    S8;
typedef volatile signed long           VS32;
typedef volatile signed short          VS16;
typedef volatile signed char           VS8;
typedef unsigned long                  U32;
typedef unsigned short                 U16;
typedef unsigned char                  U8;
typedef unsigned long  const           UC32;  
typedef unsigned short const           UC16;
typedef unsigned char  const           UC8;
typedef volatile unsigned long         VU32;
typedef volatile unsigned short        VU16;
typedef volatile unsigned char         VU8;
typedef volatile unsigned long  const  VUC32;  
typedef volatile unsigned short const  VUC16;  
typedef volatile unsigned char  const  VUC8;   
typedef volatile U8  *                 U8P;
typedef volatile U16 *                 U16P;
typedef volatile U32 *                 U32P;
typedef volatile S8  *                 S8P;
typedef volatile S16 *                 S16P;
typedef volatile S32 *                 S32P;

typedef enum {FALSE = 0, TRUE = !FALSE} boolean;

#define U8_MAX     ((U8)255)
#define S8_MAX     ((S8)127)
#define S8_MIN     ((S8)-128)
#define U16_MAX    ((U16)65535u)
#define S16_MAX    ((S16)32767)
#define S16_MIN    ((S16)-32768)
#define U32_MAX    ((U32)4294967295uL)
#define S32_MAX    ((S32)2147483647)
#define S32_MIN    ((S32)2147483648uL)

#define NUM_CHAR_IN_ULONG sizeof(unsigned long)
#define NUM_BITS_IN_ULONG (NUM_CHAR_IN_ULONG * CHAR_BIT)

#define MAKE_UINT16(lsb,msb) (unsigned short)(lsb) | (((unsigned short)(msb)) << 8)
#define MAKE_ULONG(byte1,byte2,byte3,byte4) (unsigned long)(byte1) | (((unsigned long)(byte2)) << 8) | (((unsigned long)(byte3)) << 16) | (((unsigned long)(byte4)) << 24)
#define XTRCT_BITS(byte,numbits,offset)  (byte  & (((0x1 << numbits)-1)<< offset))
#define XTRCT_VALUE(byte,numbits,offset) ((byte >> offset) & ((0x1 << numbits)-1))
#define SET_BITS(byte,numbits,offset,value) ((byte & ~(((0x1 << numbits)-1) << offset)) | (value << offset))

